from tkinter import ttk
import platform

# Colors and style definitions
THEME = {
    "background_color": "#2d2d2d",  # Default background for the UI
    "left_panel_bg": "#333333",
    "right_panel_bg": "#222222",

    "text_color": "#ffffff",
    "highlight_color": "#4a90e2",

    # Fonts
    "font_family": "Segoe UI",
    "font_size": 11,

    # Slider styling
    "slider_trough_color": "#555555",
    "slider_background_color": "#4a90e2",

    # Button styling
    "button_bg": "#444444",
    "button_fg": "#ffffff",
    "button_active_bg": "#5a9bee",
    "button_active_fg": "#ffffff",
    "button_disabled_fg": "#888888",

    "label_bg": "#333333",
    "label_fg": "#ffffff",

    "border_color": "#0078D7",
}


def setup_styles(root):
    style = ttk.Style(root)
    style.theme_use("clam")  # stable base theme

    system = platform.system()

    # --- Scale (slider) style ---
    style.configure(
        "TScale",
        troughcolor=THEME["slider_trough_color"],
    )
    if system != "Windows":  # Windows ttk crashes with these options
        style.configure(
            "TScale",
            background=THEME["slider_background_color"],
        )

    # --- Button style ---
    style.configure(
        "TButton",
        font=(THEME["font_family"], THEME["font_size"], "bold"),
        padding=6,
    )
    style.map(
        "TButton",
        background=[
            ("active", THEME["button_active_bg"]),
            ("!disabled", THEME["button_bg"]),
        ],
        foreground=[
            ("active", THEME["button_active_fg"]),
            ("disabled", THEME["button_disabled_fg"]),
        ],
    )

    # --- Label style ---
    style.configure(
        "TLabel",
        background=THEME["label_bg"],  # Keep background color for labels
        foreground=THEME["label_fg"],
        font=(THEME["font_family"], THEME["font_size"]),
    )

    # --- Frame style --- 
    # No background for TFrame as the background color will be handled by the image
    style.configure("TFrame", background='')  # Removed background color for frames to allow transparency

    return style
